$(document).ready(function() {
    // Initially hide all fieldsets except the first one
    $('.modal-body fieldset').not(':first').hide();

    // Next button click handler
    $('[data-step-to="next"]').click(function() {
        var currentStep = parseInt($('#exampleModal1').attr('data-current-step'));
        var nextStep = currentStep + 1;

        $('[data-step="' + currentStep + '"]').hide();
        $('[data-step="' + nextStep + '"]').show();

        $('#exampleModal1').attr('data-current-step', nextStep);
    });

    // Previous button click handler
    $('[data-step-to="prev"]').click(function() {
        var currentStep = parseInt($('#exampleModal1').attr('data-current-step'));
        var prevStep = currentStep - 1;

        $('[data-step="' + currentStep + '"]').hide();
        $('[data-step="' + prevStep + '"]').show();

        $('#exampleModal1').attr('data-current-step', prevStep);
    });
});
document.getElementById('uploadLink').addEventListener('click', function() {
    // Trigger click event on file input element
    document.getElementById('fileInput').click();
});

// Optional: Handle file selection change event if needed
document.getElementById('fileInput').addEventListener('change', function(event) {
    // Handle file selection
    console.log('File selected:', event.target.files[0]);
});


