@extends('admin.layouts.app')

@section('content')
<style>
    .table {
        width: 100%;
        height: auto;
    }

    .table-bordered,
    .table-bordered td,
    .table-bordered th {
        border-width: 1px;
    }

    .table-hover tbody tr:hover {
        background-color: #eee;
    }

    .card-table {
        border-radius: 10px;
        box-shadow: 0 6px 30px rgba(182, 186, 203, 0.3);
        transition: box-shadow 0.2s ease-in-out;
    }

    .card-table .card-body {
        flex: 1 1 auto !important;
        padding: 15px 14px !important;
        margin-top: 20px;
    }

    tbody,
    td,
    tfoot,
    th,
    thead,
    tr {
        border: none;
    }

    .table tbody td {
        vertical-align: bottom;
        border-bottom: 1px solid #dee2e6;
    }

    .table thead th {
        border-bottom: 1px solid #dee2e6;
        background-color: #f8f9fd;
    }

    .table th,
    .table td {
        vertical-align: middle;
        border: none;
    }

    .page-item:first-child .page-link {
        border-top-left-radius: 10px !important;
        border-bottom-left-radius: 10px !important;
    }

    .page-item:last-child .page-link {
        border-top-right-radius: 10px !important;
        border-bottom-right-radius: 10px !important;
    }

    .page-link {
        padding: 0.375rem 0.85rem !important;
        color: #293240;
    }

    .page-item.active .page-link {
        z-index: 3;
        color: #ffffff;
        background-color: #51459d;
        border-color: #51459d;
    }

    .btn-icon {
        display: inline-flex;
        align-items: center;
        color: #ffffff;
        background-color: #51459d;
        border-color: #51459d;
    }

    .btn-icon .icon {
        margin-right: 5px;
    }

    @media (max-width: 767.98px) {

        .table th,
        .table td {
            font-size: 12px;
        }

        .col-md-9 {
            padding: 0;
        }

        .col-md-3 {
            padding: 0;
        }

        .per-1 {
            font-size: 13px;
        }

        .btn-icon {
            font-size: 12px;
        }
    }
</style>
<section class="content">
    <div class="container-fluid">
        <div style="height: 20px;" class="w-100"></div>
        <div class="card card-table">
            <div class="card-header">
                <h3>RFID Products</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-9">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="d-md-flex gap-2">
                                <button class="btn btn-primary btn-sm btn-icon" data-bs-toggle="modal" data-bs-target="#createModal"><i class="fas fa-plus icon"></i> Create</button>
                                <button class="btn btn-light btn-sm btn-icon rounded-1" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="fas fa-file-export icon"></i> Export
                                </button>
                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                    <li><a id="export-csv" class="dropdown-item text-danger" href="#"><i class="fas fa-file-csv"></i> CSV</a></li>
                                </ul>
                                <button id="reset-button" class="btn btn-light btn-sm btn-icon"><i class="fas fa-redo icon"></i> Reset</button>
                                <button id="reload-button" class="btn btn-light btn-sm btn-icon"><i class="fas fa-sync-alt icon"></i> Reload</button>
                                <select id="rows-select" class="form-select form-select-sm select-icon">
                                    <option selected>Show 10 rows</option>
                                    <option value="1">Show 25 rows</option>
                                    <option value="2">Show 50 rows</option>
                                    <option value="3">Show 100 rows</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="d-flex justify-content-end align-items-center mb-3">
                            <div class="input-group input-group-sm">
                                <input id="search-input" type="text" class="form-control" placeholder="Search...">
                                <button class="btn btn-light" type="button"><i class="fas fa-search"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table id="data-table" class="table table-bordered table-hover border-0">
                                <thead>
                                    <tr>
                                        <th scope="col">Name</th>
                                        <th scope="col">SKU </th>
                                        <th scope="col">Category </th>
                                        <th scope="col">Dimensions</th>
                                        <th scope="col">Total Price</th>
                                        <th scope="col">Product Price</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><img style="width: 35px; padding-right:10px;" src="{{asset('admin-assets/img/m1.png')}}" alt=""> Ear Tops</td>
                                        <td>SKU-004</td>
                                        <td>Rings</td>
                                        <td>324 x 23 x 23</td>
                                        <td>10120.95</td>
                                        <td>10212.95</td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-light dropdown-toggle" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">Action</button>
                                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                    <li><a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#editModal"><i class="fas fa-edit"></i> Edit</a></li>
                                                    <li><a class="dropdown-item text-danger" href="#" data-bs-toggle="modal" data-bs-target="#TagModal"><i class="fas fa-tags"></i> Tags</a></li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><img style="width: 35px; padding-right:10px;" src="{{asset('admin-assets/img/m2.png')}}" alt="">Bracelet</td>
                                        <td>B-001</td>
                                        <td>Bracelet</td>
                                        <td>10 x 10 x 10</td>
                                        <td>3373.65</td>
                                        <td>7873.65</td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-light dropdown-toggle" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">Action</button>
                                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                    <li><a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#editModal"><i class="fas fa-edit"></i> Edit</a></li>
                                                    <li><a class="dropdown-item text-danger" href="#" data-bs-toggle="modal" data-bs-target="#TagModal"><i class="fas fa-tags"></i> Tags</a></li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><img style="width: 35px; padding-right:10px;" src="{{asset('admin-assets/img/m3.png')}}" alt="">Ring</td>
                                        <td>R-001</td>
                                        <td>Rings</td>
                                        <td>15 x 15 x 15</td>
                                        <td>3097.05</td>
                                        <td>3097.05</td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-light dropdown-toggle" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">Action</button>
                                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                    <li><a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#editModal"><i class="fas fa-edit"></i> Edit</a></li>
                                                    <li><a class="dropdown-item text-danger" href="#" data-bs-toggle="modal" data-bs-target="#TagModal"><i class="fas fa-tags"></i> Tags</a></li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><img style="width: 35px; padding-right:10px;" src="{{asset('admin-assets/img/m4.png')}}" alt="">Wrist Watch</td>
                                        <td>SKU43</td>
                                        <td>Bracelet</td>
                                        <td>243 x 123 x 45</td>
                                        <td>58194.6</td>
                                        <td>59758.6</td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-light dropdown-toggle" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">Action</button>
                                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                    <li><a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#editModal"><i class="fas fa-edit"></i> Edit</a></li>
                                                    <li><a class="dropdown-item text-danger" href="#" data-bs-toggle="modal" data-bs-target="#TagModal"><i class="fas fa-tags"></i> Tags</a></li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <p class="mb-0 per-1">Showing 1 to 5 of 5 entries</p>
                            <nav aria-label="Page navigation">
                                <ul class="pagination pagination-sm mb-0">
                                    <li class="page-item disabled">
                                        <a class="page-link" href="#" tabindex="-1" aria-disabled="true">Previous</a>
                                    </li>
                                    <li class="page-item active"><a class="page-link" href="#">1</a></li>
                                    <li class="page-item">
                                        <a class="page-link" href="#">Next</a>
                                    </li>
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!--// create modal// -->
<div class="modal fade" id="createModal" tabindex="-1" aria-labelledby="createModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <form id="createForm">
                <div class="modal-header">
                    <h5 class="modal-title" id="createModalLabel">Create RFID Product</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">

                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="productName" class="form-label">Product Name (اسم المنتج)</label>
                                <input type="text" class="form-control" id="productName" placeholder="Product Name (اسم المنتج)">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="sku" class="form-label">SKU</label>
                                <input type="text" class="form-control" id="sku" placeholder="SKU">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="category" class="form-label">Category (فئة)</label>
                                <select class="form-control" id="category">
                                    <option>Please Select</option>
                                    <!-- Add options here -->
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="metalType" class="form-label">Metal Type</label>
                                <select class="form-control" id="metalType">
                                    <option>Please Select</option>
                                    <!-- Add options here -->
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="stoneWeight" class="form-label">Stone Weight (GRAM) (وزن الحجر)</label>
                                <input type="text" class="form-control" id="stoneWeight" placeholder="Stone Weight (gram)">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="weight" class="form-label">Weight (GRAM) (وزن)</label>
                                <input type="text" class="form-control" id="weight" placeholder="Weight (gram)">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="productImage" class="form-label">Product Image (صورة المنتج)</label>
                                <input type="file" class="form-control" id="productImage">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="width" class="form-label">Width (CM) (عرض)</label>
                                <input type="text" class="form-control" id="width" placeholder="Width (CM)">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="height" class="form-label">Height (CM) (ارتفاع)</label>
                                <input type="text" class="form-control" id="height" placeholder="Height (CM)">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="depth" class="form-label">Depth (CM) (عمق)</label>
                                <input type="text" class="form-control" id="depth" placeholder="Depth (CM)">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="designCode" class="form-label">Design Code (كود التصميم)</label>
                                <input type="text" class="form-control" id="designCode" placeholder="Design Code">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="color" class="form-label">Color (اللون)</label>
                                <input type="text" class="form-control" id="color" placeholder="Color">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="stonesCost" class="form-label">Stones Cost (الحجارة)</label>
                                <input type="text" class="form-control" id="stonesCost" placeholder="Stones Cost">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="labourCost" class="form-label">Labour Cost (تغيب)</label>
                                <input type="text" class="form-control" id="labourCost" placeholder="Labour Cost">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="impurityCost" class="form-label">Impurity Cost (نجاسة)</label>
                                <input type="text" class="form-control" id="impurityCost" placeholder="Impurity Cost">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="otherCost" class="form-label">Other Cost (آخرون)</label>
                                <input type="text" class="form-control" id="otherCost" placeholder="Other Cost">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="status" class="form-label">Status (حالة)</label>
                                <select class="form-control" id="status">
                                    <option>In Stock</option>
                                    <!-- Add options here -->
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="rate" class="form-label">Rate (معدل)</label>
                                <input type="text" class="form-control" id="rate" placeholder="Rate">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="totalPrice" class="form-label">Total Price (السعر الكلي)</label>
                                <input type="text" class="form-control" id="totalPrice" placeholder="Total Price">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="productPrice" class="form-label">Product Price (سعر المنتج)</label>
                                <input type="text" class="form-control" id="productPrice" placeholder="Product Price">
                            </div>
                        </div>
                        <div class="col-md-4"></div>
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="productPrice" class="form-label">Description</label>
                                <textarea class="form-control" name="" id="" rows="4">

                                </textarea>
                            </div>
                        </div>
                        <input type="button" value="Submit" class="btn btn-success px-3 py-1">


                    </div>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light border px-3 py-1 " data-bs-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- #  delete modal // -->

<div class="modal fade" id="TagModal" tabindex="-1" role="dialog" aria-labelledby="Tag" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title custom_align" id="Heading">Create Tag </h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

            </div>
            <div class="modal-body">
                <form action="">
                    <div class="form-grop mb-2">
                        <label for="" class=" form-label">TAG ID :</label>
                        <input type="text" class="form-control">

                    </div>
                    <input type="button" value="Submit" class="btn btn-success px-3 py-1">
                </form>
                <div class="table-responsive mt-2">

                    <table class="table">
                        <thead>
                            <tr>
                                <th>TAG ID</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <td>E280689400004026C993B16F</td>
                            <td>
                                <input type="button" value="Delete" class="btn btn-danger px-3 py-1">
                            </td>
                        </tbody>
                    </table>
                </div>

            </div>
            <div class="modal-footer">
                <!-- <button type="button" class="btn btn-default" data-bs-dismiss="modal">No</button>
                <button type="submit" class="btn btn-success">Yes</button> -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>



@endsection
<!-- Create Modal -->


@section('customJs')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('export-csv').addEventListener('click', function() {
            var table = document.querySelector('.table');
            TableExport(table, {
                formats: ['csv'],
                filename: 'table_export',
                sheetname: 'table_data'
            }).export();
        });
    });

    document.addEventListener('DOMContentLoaded', function() {
        var rowsSelect = document.getElementById('rows-select');
        var tableRows = document.querySelectorAll('.table tbody tr');

        rowsSelect.addEventListener('change', function() {
            var selectedValue = parseInt(this.value);
            for (var i = 0; i < tableRows.length; i++) {
                if (i < selectedValue) {
                    tableRows[i].style.display = '';
                } else {
                    tableRows[i].style.display = 'none';
                }
            }
        });
    });

    document.addEventListener('DOMContentLoaded', function() {
        var resetButton = document.getElementById('reset-button');
        var reloadButton = document.getElementById('reload-button');

        resetButton.addEventListener('click', function() {
            document.querySelectorAll('.table tbody td').forEach(function(cell) {
                cell.textContent = '';
            });
            console.log('Table values reset');
        });

        reloadButton.addEventListener('click', function() {
            location.reload();
            console.log('Page reloaded');
        });
    });

    $(document).ready(function() {
        $('#search-input').on('input', function() {
            var searchText = $(this).val().toLowerCase();
            $('#data-table tbody tr').each(function() {
                var rowData = $(this).text().toLowerCase();
                if (rowData.includes(searchText)) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
    });
</script>
@endsection