@extends('admin.layouts.app')
@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Dashboard</h1>
            </div>
            <div class="col-sm-6">

            </div>
        </div>
    </div>
    <!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <!-- Default box -->
    <div class="container-fluid">


        <!-- Dashboard include there -->
        <div class="row">
            <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                    <div class="inner text-center">
                        <h3>847</h3>
                        <p>Total Customers </p>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-6">
                <div class="small-box bg-warning">
                    <div class="inner text-center">
                        <h3>689</h3>
                        <p>Total Inventory</p>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-6">
                <div class="small-box bg-success">
                    <div class="inner text-center">
                        <h3>86</h3>
                        <p>Total Orders</p>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-6">
                <div class="small-box bg-primary">
                    <div class="inner text-center">
                        <h3>977</h3>
                        <p>Total Sales</p>
                    </div>
                </div>
            </div>


        </div>

        <!-- Additional dashboard sections -->
        <div class="row">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Customer acquisition trend</h3>
                    </div>
                    <div class="card-body">
                        <canvas id="acquisitionTrend"></canvas>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Inventory state summary</h3>
                    </div>
                    <div class="card-body d-flex align-items-center justify-content-center">
                        <style>
                            #assetStateSummary {
                                height: 222px !important;
                            }
                        </style>
                        <canvas id="assetStateSummary"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Number of orders by product type</h3>
                    </div>
                    <div class="card-body">
                        <canvas id="ownershipChanges"></canvas>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Avg. sales by region</h3>
                    </div>
                    <div class="card-body">
                        <canvas id="avgOwnershipPeriod"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /.card -->
</section>
<!-- /.content -->
@endsection

@section('customJs')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Data for charts
    const acquisitionTrendCtx = document.getElementById('acquisitionTrend').getContext('2d');
    const acquisitionTrendChart = new Chart(acquisitionTrendCtx, {
        type: 'bar',
        data: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
            datasets: [{
                label: 'New Customers',
                data: [10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65],
                backgroundColor: '#4bc0c0'
            }]
        },
        options: {
            responsive: true,
            scales: {
                x: {
                    stacked: true,
                    position: 'bottom',
                    ticks: {
                        font: {
                            size: 10,
                            weight: 600,
                            color: '#000'
                        }
                    }
                },
                y: {
                    stacked: true,
                    position: 'left'
                }
            },
            plugins: {
                legend: {
                    position: 'right'
                }
            }
        }
    });

    const assetStateSummaryCtx = document.getElementById('assetStateSummary').getContext('2d');
    const assetStateSummaryChart = new Chart(assetStateSummaryCtx, {
        type: 'pie',
        data: {
            labels: ['Available', 'In Use', 'Out of Stock'],
            datasets: [{
                data: [300, 200, 189],
                backgroundColor: ['#ff6384', '#36a2eb', '#ffce56']
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'right'
                }
            }
        }
    });

    const ownershipChangesCtx = document.getElementById('ownershipChanges').getContext('2d');
    const ownershipChangesChart = new Chart(ownershipChangesCtx, {
        type: 'bar',
        data: {
            labels: ['Product A', 'Product B', 'Product C', 'Product D', 'Product E', 'Product F'],
            datasets: [{
                label: 'Number of Orders',
                data: [50, 40, 30, 20, 10, 5],
                backgroundColor: '#36a2eb'
            }]
        }
    });

    const avgOwnershipPeriodCtx = document.getElementById('avgOwnershipPeriod').getContext('2d');
    const avgOwnershipPeriodChart = new Chart(avgOwnershipPeriodCtx, {
        type: 'bar',
        data: {
            labels: ['North America', 'Europe', 'Asia', 'South America', 'Africa'],
            datasets: [{
                label: 'Avg. Sales',
                data: [500, 400, 300, 200, 100],
                backgroundColor: '#4bc0c0'
            }]
        }
    });
</script>

@endsection