@extends('admin.layouts.app')

@section('content')
<style>
    .table {
        width: 100%;
        height: auto;
    }

    .table-bordered,
    .table-bordered td,
    .table-bordered th {
        border-width: 1px;
    }

    .table-hover tbody tr:hover {
        background-color: #eee;
    }

    .card-table {
        border-radius: 10px;
        box-shadow: 0 6px 30px rgba(182, 186, 203, 0.3);
        transition: box-shadow 0.2s ease-in-out;
    }

    .card-table .card-body {
        flex: 1 1 auto !important;
        padding: 15px 14px !important;
        margin-top: 20px;
    }

    tbody,
    td,
    tfoot,
    th,
    thead,
    tr {
        border: none;
    }

    .table tbody td {
        vertical-align: bottom;
        border-bottom: 1px solid #dee2e6;
    }

    .table thead th {
        border-bottom: 1px solid #dee2e6;
        background-color: #f8f9fd;
    }

    .table th,
    .table td {
        vertical-align: middle;
        border: none;
    }

    .page-item:first-child .page-link {
        border-top-left-radius: 10px !important;
        border-bottom-left-radius: 10px !important;
    }

    .page-item:last-child .page-link {
        border-top-right-radius: 10px !important;
        border-bottom-right-radius: 10px !important;
    }

    .page-link {
        padding: 0.375rem 0.85rem !important;
        color: #293240;
    }

    .page-item.active .page-link {
        z-index: 3;
        color: #ffffff;
        background-color: #51459d;
        border-color: #51459d;
    }

    .btn-icon {
        display: inline-flex;
        align-items: center;
        color: #ffffff;
        background-color: #51459d;
        border-color: #51459d;
    }

    .btn-icon .icon {
        margin-right: 5px;
    }

    .invoice-header {
        
        padding: 10px;
        border-radius: 5px;
        margin-bottom: 20px;
    }

    .invoice-body {
        background-color: white;
        padding: 20px;
        border-radius: 5px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }

    .company-details,
    .customer-details,
    .invoice-details {
        margin-bottom: 20px;
    }

    

    @media (max-width: 767.98px) {

        .table th,
        .table td {
            font-size: 12px;
        }

        .col-md-9 {
            padding: 0;
        }

        .col-md-3 {
            padding: 0;
        }

        .per-1 {
            font-size: 13px;
        }

        .btn-icon {
            font-size: 12px;
        }
    }
</style>
<section class="content">
    <div class="container-fluid">
        <div style="height: 20px;" class="w-100"></div>
        <div class="card card-table">
            <div class="card-header">
                <h3>Orders</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-9">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="d-md-flex gap-2">
                                <button class="btn btn-light btn-sm btn-icon rounded-1" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="fas fa-file-export icon"></i> Export
                                </button>
                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                    <li><a id="export-csv" class="dropdown-item text-danger" href="#"><i class="fas fa-file-csv"></i> CSV</a></li>
                                </ul>
                                <button id="reset-button" class="btn btn-light btn-sm btn-icon"><i class="fas fa-redo icon"></i> Reset</button>
                                <button id="reload-button" class="btn btn-light btn-sm btn-icon"><i class="fas fa-sync-alt icon"></i> Reload</button>
                                <select id="rows-select" class="form-select form-select-sm select-icon">
                                    <option selected>Show 10 rows</option>
                                    <option value="1">Show 25 rows</option>
                                    <option value="2">Show 50 rows</option>
                                    <option value="3">Show 100 rows</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="d-flex justify-content-end align-items-center mb-3">
                            <div class="input-group input-group-sm">
                                <input id="search-input" type="text" class="form-control" placeholder="Search...">
                                <button class="btn btn-light" type="button"><i class="fas fa-search"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table id="data-table" class="table table-bordered table-hover border-0">
                                <thead>
                                    <tr>
                                        <th scope="col">Order Num</th>
                                        <th scope="col">Contact Name</th>
                                        <th scope="col">Contact Number</th>
                                        <th scope="col">Contact Email</th>
                                        <th scope="col">Total Amount</th>
                                        <th scope="col">Total Items</th>
                                        <th scope="col">Total Amount</th>
                                        <th scope="col">Date/Time </th>
                                        <th scope="col">Action</th>


                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>Fahad Ahmed</td>
                                        <td>0587373733</td>
                                        <td>fahad@gmail.com</td>
                                        <td>68722.39</td>
                                        <td>1</td>
                                        <td>Complete</td>
                                        <td>2023-07-05 18:33:12</td>
                                        <td>
                                            <button data-bs-toggle="modal" data-bs-target="#viewModal" class="btn btn-success px-2 py-1">View</button>
                                        </td>

                                    </tr>


                                </tbody>
                            </table>
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <p class="mb-0 per-1">Showing 1 to 5 of 5 entries</p>
                            <nav aria-label="Page navigation">
                                <ul class="pagination pagination-sm mb-0">
                                    <li class="page-item disabled">
                                        <a class="page-link" href="#" tabindex="-1" aria-disabled="true">Previous</a>
                                    </li>
                                    <li class="page-item active"><a class="page-link" href="#">1</a></li>
                                    <li class="page-item">
                                        <a class="page-link" href="#">Next</a>
                                    </li>
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!--// create modal// -->
<div class="modal fade" id="viewModal" tabindex="-1" aria-labelledby="viewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="container">
                <div class="invoice-header text-left">
                    <img class="img-fluid"  src="{{asset('admin-assets/img/nazam-logo.png')}}" alt="">
                    
                    <h4>Jewellery Management System</h4>
                </div>
                <div class="invoice-body">
                    <div class="row">
                        <div class="col-md-4 company-details">
                            <h5>Company Information</h5>
                            <p>
                                3499 Anas Ibn Malik Road,<br>
                                Al Malqa, Riyadh, Saudi Arabia<br>
                                Phone: +966-556545240<br>
                                Email: info@nazm-aliyyad.com
                            </p>
                        </div>
                        <div class="col-md-4 customer-details">
                            <h5>Customer Details</h5>
                            <p>
                                Fahad Ahmed<br>
                                Phone: 0587373733<br>
                                Email: fahad@gmail.com
                            </p>
                        </div>
                        <div class="col-md-4 invoice-details text-end">
                            <h5>Invoice Details</h5>
                            <p>
                                Invoice #001<br>
                                Date: 05-07-2023 18:33:12<br>
                                Total Items: 1<br>
                                Total Amount: 68,722.39
                            </p>
                        </div>
                    </div>

                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>S.no</th>
                                <th>Product</th>
                                <th>Type</th>
                                <th>Weight</th>
                                <th>Dimensions</th>
                                <th>Price</th>
                                <th>Rate</th>
                                <th>QTY</th>
                                <th>Subtotal</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>1</td>
                                <td>Wrist Watch</td>
                                <td>Gold (18K)</td>
                                <td>345</td>
                                <td>234 x 123 x 45</td>
                                <td>59,758.60</td>
                                <td>168.68</td>
                                <td>1</td>
                                <td>59,758.60</td>
                            </tr>
                        </tbody>
                    </table>

                    <div class="row">
                        <div class="col-md-6"></div>
                        <div class="col-md-6">
                            <table class="table">
                                <tr class="totals">
                                    <th>Subtotal:</th>
                                    <td>59,758.60</td>
                                </tr>
                                <tr class="totals">
                                    <th>Discount:</th>
                                    <td>0.00</td>
                                </tr>
                                <tr class="totals">
                                    <th>Tax:</th>
                                    <td>8,963.79</td>
                                </tr>
                                <tr class="totals">
                                    <th>Total:</th>
                                    <td>68,722.39</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>




@endsection
<!-- Create Modal -->


@section('customJs')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('export-csv').addEventListener('click', function() {
            var table = document.querySelector('.table');
            TableExport(table, {
                formats: ['csv'],
                filename: 'table_export',
                sheetname: 'table_data'
            }).export();
        });
    });

    document.addEventListener('DOMContentLoaded', function() {
        var rowsSelect = document.getElementById('rows-select');
        var tableRows = document.querySelectorAll('.table tbody tr');

        rowsSelect.addEventListener('change', function() {
            var selectedValue = parseInt(this.value);
            for (var i = 0; i < tableRows.length; i++) {
                if (i < selectedValue) {
                    tableRows[i].style.display = '';
                } else {
                    tableRows[i].style.display = 'none';
                }
            }
        });
    });

    document.addEventListener('DOMContentLoaded', function() {
        var resetButton = document.getElementById('reset-button');
        var reloadButton = document.getElementById('reload-button');

        resetButton.addEventListener('click', function() {
            document.querySelectorAll('.table tbody td').forEach(function(cell) {
                cell.textContent = '';
            });
            console.log('Table values reset');
        });

        reloadButton.addEventListener('click', function() {
            location.reload();
            console.log('Page reloaded');
        });
    });

    $(document).ready(function() {
        $('#search-input').on('input', function() {
            var searchText = $(this).val().toLowerCase();
            $('#data-table tbody tr').each(function() {
                var rowData = $(this).text().toLowerCase();
                if (rowData.includes(searchText)) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
    });
</script>
@endsection