@extends('admin.layouts.app')

@section('content')
<style>
    .table {
        width: 100%;
        height: auto;
    }

    .table-bordered,
    .table-bordered td,
    .table-bordered th {
        border-width: 1px;
    }

    .table-hover tbody tr:hover {
        background-color: #eee;
    }

    .card-table {
        border-radius: 10px;
        box-shadow: 0 6px 30px rgba(182, 186, 203, 0.3);
        transition: box-shadow 0.2s ease-in-out;
    }

    .card-table .card-body {
        flex: 1 1 auto !important;
        padding: 15px 14px !important;
        margin-top: 20px;
    }

    tbody,
    td,
    tfoot,
    th,
    thead,
    tr {
        border: none;
    }

    .table tbody td {
        vertical-align: bottom;
        border-bottom: 1px solid #dee2e6;
    }

    .table thead th {
        border-bottom: 1px solid #dee2e6;
        background-color: #f8f9fd;
    }

    .table th,
    .table td {
        vertical-align: middle;
        border: none;
    }

    .page-item:first-child .page-link {
        border-top-left-radius: 10px !important;
        border-bottom-left-radius: 10px !important;
    }

    .page-item:last-child .page-link {
        border-top-right-radius: 10px !important;
        border-bottom-right-radius: 10px !important;
    }

    .page-link {
        padding: 0.375rem 0.85rem !important;
        color: #293240;
    }

    .page-item.active .page-link {
        z-index: 3;
        color: #ffffff;
        background-color: #51459d;
        border-color: #51459d;
    }

    .btn-icon {
        display: inline-flex;
        align-items: center;
        color: #ffffff;
        background-color: #51459d;
        border-color: #51459d;
    }

    .btn-icon .icon {
        margin-right: 5px;
    }

    @media (max-width: 767.98px) {

        .table th,
        .table td {
            font-size: 12px;
        }

        .col-md-9,
        .col-md-3 {
            padding: 0;
        }

        .per-1 {
            font-size: 13px;
        }

        .btn-icon {
            font-size: 12px;
        }
    }
</style>

<section class="content">
    <div class="container-fluid">
        <div style="height: 20px;" class="w-100"></div>

        <!-- Language Dictionary Card -->
        <div class="card card-table">
            <div class="card-header">
                <h3>Language Key</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-9">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="d-md-flex gap-2">
                                <button class="btn btn-primary btn-sm btn-icon"><i class="fas fa-save icon"></i> save</button>
                                <button class="btn btn-light btn-sm btn-icon rounded-1" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="fas fa-file-export icon"></i> Export
                                </button>
                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                    <li><a id="export-csv" class="dropdown-item text-danger" href="#"><i class="fas fa-file-csv"></i> CSV</a></li>
                                </ul>
                                <button id="reset-button" class="btn btn-light btn-sm btn-icon"><i class="fas fa-redo icon"></i> Reset</button>
                                <button id="reload-button" class="btn btn-light btn-sm btn-icon"><i class="fas fa-sync-alt icon"></i> Reload</button>
                                <select id="rows-select" class="form-select form-select-sm select-icon">
                                    <option selected>Show 10 rows</option>
                                    <option value="1">Show 25 rows</option>
                                    <option value="2">Show 50 rows</option>
                                    <option value="3">Show 100 rows</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="d-flex justify-content-end align-items-center mb-3">
                            <div class="input-group input-group-sm">
                                <input id="search-input" type="text" class="form-control" placeholder="Search...">
                                <button class="btn btn-light" type="button"><i class="fas fa-search"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <div class="table-container">
                                <table class="table table-bordered" id="data-table">
                                    <thead>
                                        <tr>
                                            <th>Language Key</th>
                                            <th>English</th>
                                            <th>Arabic</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td># of cloths</td>
                                            <td><input type="text" class="form-control"></td>
                                            <td><input type="text" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <td>Action</td>
                                            <td><input type="text" class="form-control" value="Action"></td>
                                            <td><input type="text" class="form-control" value="فعل"></td>
                                        </tr>
                                        <tr>
                                            <td>add more</td>
                                            <td><input type="text" class="form-control"></td>
                                            <td><input type="text" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <td>Address</td>
                                            <td><input type="text" class="form-control" value="Address"></td>
                                            <td><input type="text" class="form-control" value="عنوان"></td>
                                        </tr>
                                        <tr>
                                            <td>Allocated</td>
                                            <td><input type="text" class="form-control"></td>
                                            <td><input type="text" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <td>Antenna 1 Power</td>
                                            <td><input type="text" class="form-control"></td>
                                            <td><input type="text" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <td>Antenna 10 Power</td>
                                            <td><input type="text" class="form-control"></td>
                                            <td><input type="text" class="form-control"></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="pagination">
                                <nav>
                                    <ul class="pagination">
                                        <li class="page-item disabled">
                                            <a class="page-link" href="#" tabindex="-1" aria-disabled="true">Previous</a>
                                        </li>
                                        <li class="page-item active" aria-current="page"><a class="page-link" href="#">1</a></li>
                                        <li class="page-item"><a class="page-link" href="#">2</a></li>
                                        <li class="page-item"><a class="page-link" href="#">3</a></li>
                                        <li class="page-item">
                                            <a class="page-link" href="#">Next</a>
                                        </li>
                                    </ul>
                                </nav>
                            </div>
                            <div class="per-1">Showing 1 to 10 of 57 entries</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


@endsection

@section('customJs')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('export-csv').addEventListener('click', function() {
            var table = document.querySelector('.table');
            TableExport(table, {
                formats: ['csv'],
                filename: 'table_export',
                sheetname: 'table_data'
            }).export();
        });
    });

    document.addEventListener('DOMContentLoaded', function() {
        var rowsSelect = document.getElementById('rows-select');
        var tableRows = document.querySelectorAll('.table tbody tr');

        rowsSelect.addEventListener('change', function() {
            var selectedValue = parseInt(this.value);
            for (var i = 0; i < tableRows.length; i++) {
                if (i < selectedValue) {
                    tableRows[i].style.display = '';
                } else {
                    tableRows[i].style.display = 'none';
                }
            }
        });
    });

    document.addEventListener('DOMContentLoaded', function() {
        var resetButton = document.getElementById('reset-button');
        var reloadButton = document.getElementById('reload-button');

        resetButton.addEventListener('click', function() {
            document.querySelectorAll('.table tbody td').forEach(function(cell) {
                cell.textContent = '';
            });
            console.log('Table values reset');
        });

        reloadButton.addEventListener('click', function() {
            location.reload();
            console.log('Page reloaded');
        });
    });

    $(document).ready(function() {
        $('#search-input').on('input', function() {
            var searchText = $(this).val().toLowerCase();
            $('#data-table tbody tr').each(function() {
                var rowData = $(this).text().toLowerCase();
                if (rowData.includes(searchText)) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
    });
</script>
@endsection