<?php

use App\Http\Controllers\Admin\AdminLoginController;
use App\Http\Controllers\Admin\HomeController;
use Illuminate\Routing\RouteGroup;
use Illuminate\Support\Facades\Route;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::redirect('/', '/admin/login');

Route::group(['prefix' => 'admin'], function () {
    Route::group(['middleware' => 'admin.guest'], function () {

        Route::get('/login', [AdminLoginController::class, 'index'])->name('admin.login');
        Route::post('/authenticate', [AdminLoginController::class, 'authenticate'])->name('admin.authenticate');

    });
    Route::group(['middleware' => 'admin.auth'], function () {
        Route::get('/dashboard', [HomeController::class, 'index'])->name('admin.dashboard');
        Route::get('/assets', [HomeController::class, 'view'])->name('admin.assets');
        
        Route::get('/logout', [HomeController::class, 'logout'])->name('admin.logout');
        
    });
});
Route::view('/rfidDevices','admin.rfidDevices');
Route::view('/TagReader','admin.TagReader');
Route::view('/departments','admin.departments');
Route::view('/users','admin.users');
Route::view('/roles','admin.Roles');
Route::view('/rolPer','admin.Roles&Permission');
Route::view('/products','admin.Products');
Route::view('/categories','admin.categories');
Route::view('/language-dictionary','admin.language-dictionary');
Route::view('/jewellery-orders','admin.jewellery-orders');
Route::view('/rates','admin.rates');
Route::view('/media','admin.media');





















